/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.HttpFieldName;
import cool.scx.http.ParametersWritable;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.content_disposition.ContentDispositionWritable;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.content_type.ContentTypeWritable;
import cool.scx.http.cookie.Cookie;
import cool.scx.http.cookie.Cookies;
import cool.scx.http.cookie.CookiesWritable;

public interface ScxHttpHeadersWritable
extends ScxHttpHeaders,
ParametersWritable<ScxHttpHeaderName, String> {
    default public ScxHttpHeadersWritable set(String name, String ... value) {
        this.set(ScxHttpHeaderName.of(name), value);
        return this;
    }

    default public ScxHttpHeadersWritable add(String name, String ... value) {
        this.add(ScxHttpHeaderName.of(name), value);
        return this;
    }

    default public ScxHttpHeadersWritable remove(String name) {
        this.remove(ScxHttpHeaderName.of(name));
        return this;
    }

    @Override
    default public CookiesWritable cookies() {
        return Cookies.of((String)this.get(HttpFieldName.COOKIE));
    }

    default public ScxHttpHeadersWritable cookies(Cookies cookies) {
        this.set(HttpFieldName.COOKIE, cookies.encodeCookie());
        return this;
    }

    @Override
    default public CookiesWritable setCookies() {
        return Cookies.of((String[])this.getAll(HttpFieldName.SET_COOKIE).toArray(String[]::new));
    }

    default public ScxHttpHeadersWritable setCookies(Cookies cookies) {
        this.set(HttpFieldName.SET_COOKIE, cookies.encodeSetCookie());
        return this;
    }

    @Override
    default public ContentTypeWritable contentType() {
        return ContentType.of((String)this.get(HttpFieldName.CONTENT_TYPE));
    }

    default public ScxHttpHeadersWritable contentType(ContentType contentType) {
        this.set(HttpFieldName.CONTENT_TYPE, contentType.encode());
        return this;
    }

    @Override
    default public ContentDispositionWritable contentDisposition() {
        return ContentDisposition.of((String)this.get(HttpFieldName.CONTENT_DISPOSITION));
    }

    default public ScxHttpHeadersWritable contentDisposition(ContentDisposition contentDisposition) {
        this.set(HttpFieldName.CONTENT_DISPOSITION, contentDisposition.encode());
        return this;
    }

    default public ScxHttpHeadersWritable addCookie(Cookie cookie) {
        CookiesWritable cookies = this.cookies();
        cookies.add(cookie);
        return this.cookies(cookies);
    }

    default public ScxHttpHeadersWritable removeCookie(String name) {
        CookiesWritable cookies = this.cookies();
        cookies.remove(name);
        return this.cookies(cookies);
    }

    default public ScxHttpHeadersWritable addSetCookie(Cookie cookie) {
        CookiesWritable cookies = this.setCookies();
        cookies.add(cookie);
        return this.setCookies(cookies);
    }

    default public ScxHttpHeadersWritable removeSetCookie(String name) {
        CookiesWritable cookies = this.setCookies();
        cookies.remove(name);
        return this.setCookies(cookies);
    }

    default public ScxHttpHeadersWritable contentLength(long contentLength) {
        this.set(HttpFieldName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this;
    }
}

