/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.cookie;

import cool.scx.http.cookie.Cookie;
import cool.scx.http.cookie.CookieImpl;
import cool.scx.http.cookie.CookieSameSite;
import cool.scx.http.cookie.Cookies;
import cool.scx.http.cookie.CookiesImpl;
import java.util.ArrayList;

public class CookieHelper {
    public static CookiesImpl parseCookies(String cookieStr) {
        CookiesImpl cookies = new CookiesImpl();
        if (cookieStr != null) {
            String[] c;
            for (String cookie : c = cookieStr.split(";\\s")) {
                String[] parts = cookie.split("=", 2);
                if (parts.length != 2) continue;
                cookies.add(Cookie.of(parts[0], parts[1]));
            }
        }
        return cookies;
    }

    public static Cookie parseSetCookie(String setCookieHeader) {
        String[] parts = setCookieHeader.split(";\\s*");
        String[] nameValue = parts[0].split("=", 2);
        String name = nameValue[0];
        String value = nameValue.length > 1 ? nameValue[1] : "";
        CookieImpl cookie = new CookieImpl(name, value);
        for (int i = 1; i < parts.length; ++i) {
            String attrValue;
            String[] attr = parts[i].split("=", 2);
            String key = attr[0];
            String string = attrValue = attr.length > 1 ? attr[1] : "";
            if (key.equalsIgnoreCase("Domain")) {
                cookie.domain(attrValue);
                continue;
            }
            if (key.equalsIgnoreCase("Path")) {
                cookie.path(attrValue);
                continue;
            }
            if (key.equalsIgnoreCase("Max-Age")) {
                cookie.maxAge(Long.parseLong(attrValue));
                continue;
            }
            if (key.equalsIgnoreCase("SameSite")) {
                cookie.sameSite(CookieSameSite.of(attrValue));
                continue;
            }
            if (key.equalsIgnoreCase("Secure")) {
                cookie.secure(true);
                continue;
            }
            if (!key.equalsIgnoreCase("HttpOnly")) continue;
            cookie.httpOnly(true);
        }
        return cookie;
    }

    public static CookiesImpl parseSetCookie(String[] setCookies) {
        CookiesImpl c = new CookiesImpl();
        for (String str : setCookies) {
            Cookie cookies = CookieHelper.parseSetCookie(str);
            c.add(cookies);
        }
        return c;
    }

    public static String encodeCookie(Cookie cookie) {
        StringBuilder buf = new StringBuilder().append(cookie.name()).append('=').append(cookie.value());
        if (cookie.domain() != null) {
            buf.append("; Domain=").append(cookie.domain());
        }
        if (cookie.path() != null) {
            buf.append("; Path=").append(cookie.path());
        }
        if (cookie.maxAge() != null) {
            buf.append("; Max-Age=").append(cookie.maxAge());
        }
        if (cookie.sameSite() != null) {
            buf.append("; SameSite=").append(cookie.sameSite().value());
        }
        if (cookie.secure()) {
            buf.append("; Secure");
        }
        if (cookie.httpOnly()) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    public static String encodeCookie(Cookies cookies) {
        ArrayList<String> sb = new ArrayList<String>();
        for (Cookie cookie : cookies) {
            String s = CookieHelper.encodeCookie(cookie);
            sb.add(s);
        }
        return String.join((CharSequence)"; ", sb);
    }

    public static String[] encodeSetCookie(Cookies cookies) {
        ArrayList<String> s = new ArrayList<String>();
        for (Cookie cookie : cookies) {
            String s1 = CookieHelper.encodeCookie(cookie);
            s.add(s1);
        }
        return (String[])s.toArray(String[]::new);
    }
}

