/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.path;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathHelper {
    public static long getFileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fileCopy(Path path, OutputStream out) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             OutputStream outputStream = out;){
            inputStream.transferTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fileCopyWithOffset(Path path, OutputStream out, long offset, long length) {
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);
             WritableByteChannel outChannel = Channels.newChannel(out);){
            int toWrite;
            channel.position(offset);
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            for (long toRead = length; toRead > 0L; toRead -= (long)toWrite) {
                int read = channel.read(buffer);
                if (read == -1) {
                    break;
                }
                buffer.flip();
                toWrite = (int)Math.min(toRead, (long)read);
                buffer.limit(toWrite);
                outChannel.write(buffer);
                buffer.clear();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

