/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.Parameters;
import cool.scx.http.ParametersWritable;
import cool.scx.http.routing.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathMatcherImpl
implements PathMatcher {
    private static final String RE_VAR_NAME = "[A-Za-z0-9_]+";
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":([A-Za-z0-9_]+)");
    private static final Pattern RE_TOKEN_NAME_SEARCH = Pattern.compile("\\(\\?<([A-Za-z0-9_]+)>");
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([()$+.])");
    private String path = null;
    private Pattern pattern = null;
    private List<String> groups = null;
    private Set<String> namedGroupsInRegex = null;
    private boolean pathEndsWithSlash = false;
    private boolean exactPath = true;

    PathMatcherImpl() {
    }

    private static boolean pathMatchesExact(String base, String other, boolean significantSlash) {
        int len = other.length();
        if (significantSlash) {
            if (other.charAt(len - 1) != '/') {
                return false;
            }
        } else if (other.charAt(len - 1) == '/') {
            if (base.length() != --len) {
                return false;
            }
            return other.regionMatches(0, base, 0, len);
        }
        return other.equals(base);
    }

    private static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    void checkPath(String path) {
        if ("".equals(path) || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with /");
        }
    }

    void setPath(String path) {
        int found;
        if (path.charAt(path.length() - 1) != '*') {
            this.exactPath = true;
            this.path = path;
        } else {
            this.exactPath = false;
            this.path = path.substring(0, path.length() - 1);
        }
        this.pathEndsWithSlash = this.path.endsWith("/");
        int params = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != ':') continue;
            ++params;
        }
        if (params > 0 && params != (found = this.createPatternRegex(path))) {
            throw new IllegalArgumentException("path param does not follow the variable naming rules, expected (" + params + ") found (" + found + ")");
        }
    }

    private int createPatternRegex(String path) {
        if (((String)(path = RE_OPERATORS_NO_STAR.matcher((CharSequence)path).replaceAll("\\\\$1"))).charAt(((String)path).length() - 1) == '*') {
            path = ((String)path).substring(0, ((String)path).length() - 1) + "(?<rest>.*)";
            this.exactPath = false;
        } else {
            this.exactPath = true;
        }
        Matcher m = RE_TOKEN_SEARCH.matcher((CharSequence)path);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> groups = new ArrayList<String>();
        int index = 0;
        while (m.find()) {
            String param = "p" + index;
            String group = m.group().substring(1);
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            groups.add(group);
            ++index;
        }
        m.appendTail(sb);
        if (this.exactPath && !this.pathEndsWithSlash) {
            sb.append("/?");
        }
        path = sb.toString();
        this.groups = groups;
        this.pattern = Pattern.compile((String)path);
        return index;
    }

    void setRegex(String regex) {
        this.pattern = Pattern.compile(regex);
        this.exactPath = true;
        this.findNamedGroups(this.pattern.pattern());
    }

    private void findNamedGroups(String path) {
        Matcher m = RE_TOKEN_NAME_SEARCH.matcher(path);
        while (m.find()) {
            this.addNamedGroupInRegex(m.group(1));
        }
    }

    private void addNamedGroupInRegex(String namedGroupInRegex) {
        if (this.namedGroupsInRegex == null) {
            this.namedGroupsInRegex = new HashSet<String>();
        }
        this.namedGroupsInRegex.add(namedGroupInRegex);
    }

    private boolean pathMatches(String requestPath, ParametersWritable<String, String> pathParams) {
        String thePath = this.path;
        boolean pathEndsWithSlash = this.pathEndsWithSlash;
        if (requestPath == null) {
            requestPath = "/";
        }
        if (this.exactPath) {
            pathParams.remove("*");
            return PathMatcherImpl.pathMatchesExact(thePath, requestPath, pathEndsWithSlash);
        }
        if (pathEndsWithSlash) {
            int pathLen = thePath.length();
            int reqLen = requestPath.length();
            if (reqLen < pathLen - 2) {
                return false;
            }
            if (reqLen == pathLen - 1 && thePath.regionMatches(0, requestPath, 0, pathLen - 1)) {
                pathParams.add("*", (String[])new String[]{"/"});
                return true;
            }
        }
        if (requestPath.startsWith(thePath)) {
            pathParams.add("*", (String[])new String[]{requestPath.substring(thePath.length())});
            return true;
        }
        return false;
    }

    private boolean matches(String requestPath, ParametersWritable<String, String> pathParams) {
        if (this.path != null && this.pattern == null && !this.pathMatches(requestPath, pathParams)) {
            return false;
        }
        if (this.pattern != null) {
            Matcher m;
            pathParams.remove("*");
            if (requestPath != null && (m = this.pattern.matcher(requestPath)).matches()) {
                int matchRest = -1;
                if (m.groupCount() > 0) {
                    if (!this.exactPath) {
                        matchRest = m.start("rest");
                        pathParams.add("*", (String[])new String[]{requestPath.substring(matchRest)});
                    }
                    if (!PathMatcherImpl.isEmpty(this.groups)) {
                        int len = Math.min(this.groups.size(), m.groupCount());
                        for (int i = 0; i < len; ++i) {
                            String undecodedValue;
                            String k = this.groups.get(i);
                            try {
                                undecodedValue = m.group("p" + i);
                            }
                            catch (IllegalArgumentException e) {
                                try {
                                    undecodedValue = m.group(k);
                                }
                                catch (IllegalArgumentException e1) {
                                    undecodedValue = m.group(i + 1);
                                }
                            }
                            if (undecodedValue == null) continue;
                            pathParams.add(k, (String[])new String[]{undecodedValue});
                        }
                    } else {
                        if (!PathMatcherImpl.isEmpty(this.namedGroupsInRegex)) {
                            for (String namedGroup : this.namedGroupsInRegex) {
                                String namedGroupValue = m.group(namedGroup);
                                if (namedGroupValue == null) continue;
                                pathParams.add(namedGroup, (String[])new String[]{namedGroupValue});
                            }
                        }
                        for (int i = 0; i < m.groupCount(); ++i) {
                            String group = m.group(i + 1);
                            if (group == null) continue;
                            String k = "param" + i;
                            pathParams.add(k, (String[])new String[]{group});
                        }
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public PathMatcher.MatchResult matches(String path) {
        ParametersWritable<String, String> pathParams = Parameters.of();
        boolean accepted = this.matches(path, pathParams);
        return new PathMatcher.MatchResult(accepted, pathParams);
    }

    public String path() {
        return this.path;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public List<String> groups() {
        return this.groups;
    }

    public boolean exactPath() {
        return this.exactPath;
    }
}

