/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing.handler;

import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.handler.StaticHelper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;

public class StaticHandler
implements Consumer<RoutingContext> {
    private final Path root;

    public StaticHandler(Path root) {
        this.root = root;
    }

    @Override
    public void accept(RoutingContext routingContext) {
        ScxHttpServerRequest request = routingContext.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            routingContext.next();
            return;
        }
        String p = routingContext.pathParams().get("*");
        Path filePath = this.getFilePath(p);
        boolean notExists = Files.notExists(filePath, new LinkOption[0]);
        if (notExists) {
            routingContext.next();
            return;
        }
        StaticHelper.sendStatic(filePath, routingContext);
    }

    public Path getFilePath(String p) {
        boolean regularFile = Files.isRegularFile(this.root, new LinkOption[0]);
        if (regularFile) {
            return this.root;
        }
        Path path = this.root.resolve(p).normalize();
        if (!path.startsWith(this.root)) {
            throw new NotFoundException();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path.resolve("index.html");
        }
        return path;
    }
}

