/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.HttpStatusCode;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.cookie.Cookie;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.byte_array.ByteArrayWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.media.input_stream.InputStreamWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartWriter;
import cool.scx.http.media.object.ObjectWriter;
import cool.scx.http.media.path.PathWriter;
import cool.scx.http.media.string.StringWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;

public interface ScxHttpServerResponse {
    public ScxHttpServerRequest request();

    public HttpStatusCode status();

    public ScxHttpHeadersWritable headers();

    public ScxHttpServerResponse status(HttpStatusCode var1);

    public OutputStream outputStream();

    public void end();

    public boolean isClosed();

    default public void send(MediaWriter writer) {
        writer.beforeWrite(this.headers(), this.request().headers());
        writer.write(this.outputStream());
        this.end();
    }

    default public ScxHttpServerResponse status(int code) {
        return this.status(HttpStatusCode.of(code));
    }

    default public void send() {
        this.send(new EmptyWriter());
    }

    default public void send(byte[] bytes) {
        this.send(new ByteArrayWriter(bytes));
    }

    default public void send(String str) {
        this.send(new StringWriter(str));
    }

    default public void send(String str, Charset charset) {
        this.send(new StringWriter(str, charset));
    }

    default public void send(Path path) {
        this.send(new PathWriter(path));
    }

    default public void send(Path path, long offset, long length) {
        this.send(new PathWriter(path, offset, length));
    }

    default public void send(InputStream inputStream) {
        this.send(new InputStreamWriter(inputStream));
    }

    default public void send(MultiPart multiPart) {
        this.send(new MultiPartWriter(multiPart));
    }

    default public void send(Object object) {
        this.send(new ObjectWriter(object));
    }

    default public ScxHttpServerResponse setHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse addHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse setHeader(String headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse addHeader(String headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse addSetCookie(Cookie ... cookie) {
        this.headers().addSetCookie(cookie);
        return this;
    }

    default public ScxHttpServerResponse removeSetCookie(String name) {
        this.headers().removeSetCookie(name);
        return this;
    }

    default public ContentType contentType() {
        return this.headers().contentType();
    }

    default public ScxHttpServerResponse contentType(ContentType contentType) {
        this.headers().contentType(contentType);
        return this;
    }

    default public Long contentLength() {
        return this.headers().contentLength();
    }

    default public ScxHttpServerResponse contentLength(long contentLength) {
        this.headers().contentLength(contentLength);
        return this;
    }
}

