/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.object;

import cool.scx.common.util.ObjectUtils;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.accept.Accept;
import cool.scx.http.accept.Accepts;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.content_type.ContentTypeWritable;
import cool.scx.http.media.MediaWriter;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ObjectWriter
implements MediaWriter {
    private final Object object;
    private byte[] data;

    public ObjectWriter(Object object) {
        this.object = object;
    }

    public static ContentTypeWritable trySetContentType(ScxHttpHeadersWritable headersWritable, ScxHttpHeaders headers) {
        ContentTypeWritable x = ContentType.of(MediaType.APPLICATION_XML).charset(StandardCharsets.UTF_8);
        ContentTypeWritable j = ContentType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8);
        if (headersWritable.contentType() == null) {
            Accepts accepts = headers.accepts();
            if (accepts != null) {
                for (Accept accept : accepts) {
                    if (accept.mediaType() != MediaType.APPLICATION_XML) continue;
                    headersWritable.contentType(x);
                    return x;
                }
            }
            headersWritable.contentType(j);
        }
        return headersWritable.contentType();
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable headersWritable, ScxHttpHeaders headers) {
        block5: {
            ContentTypeWritable ccc = ObjectWriter.trySetContentType(headersWritable, headers);
            try {
                if (ccc.mediaType() == MediaType.APPLICATION_JSON) {
                    this.data = ObjectUtils.toJson((Object)this.object).getBytes();
                    break block5;
                }
                if (ccc.mediaType() == MediaType.APPLICATION_XML) {
                    this.data = ObjectUtils.toXml((Object)this.object).getBytes();
                    break block5;
                }
                throw new RuntimeException("Unsupported media type: " + String.valueOf(ccc.mediaType()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (headersWritable.contentLength() == null) {
            headersWritable.contentLength(this.data.length);
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

