/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.uri;

import cool.scx.http.Parameters;
import cool.scx.http.ParametersWritable;
import cool.scx.http.uri.ScxURI;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScxURIHelper {
    public static ParametersWritable<String, String> decodeQuery(String value) {
        String[] split;
        ParametersWritable<String, String> query = Parameters.of();
        if (value == null) {
            return query;
        }
        for (String s : split = value.split("&")) {
            split = s.split("=", 2);
            if (split.length != 2) continue;
            query.add(split[0], (String[])new String[]{split[1]});
        }
        return query;
    }

    public static String encodeQuery(Parameters<String, String> query) {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        for (Map.Entry entry : query) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            for (String s : value) {
                String kk = URLEncoder.encode(key, StandardCharsets.UTF_8);
                String vv = URLEncoder.encode(s, StandardCharsets.UTF_8);
                l.add((CallSite)((Object)(kk + "=" + vv)));
            }
        }
        return String.join((CharSequence)"&", l);
    }

    public static String encodeURI(ScxURI uri) {
        String scheme = uri.scheme();
        String host = uri.host();
        int port = uri.port();
        String path = uri.path();
        Parameters<String, String> query = uri.query();
        String fragment = uri.fragment();
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(host);
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':');
                sb.append(port);
            }
        }
        if (path != null) {
            sb.append(URLEncoder.encode(path, StandardCharsets.UTF_8).replace("%2F", "/"));
        }
        if (query != null && !query.isEmpty()) {
            sb.append('?');
            sb.append(ScxURIHelper.encodeQuery(query));
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(URLEncoder.encode(fragment, StandardCharsets.UTF_8));
        }
        return sb.toString();
    }
}

