/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.ScxHttpMethod;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.cookie.Cookie;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.byte_array.ByteArrayWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.media.input_stream.InputStreamWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartWriter;
import cool.scx.http.media.object.ObjectWriter;
import cool.scx.http.media.path.PathWriter;
import cool.scx.http.media.string.StringWriter;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;

public interface ScxHttpClientRequest {
    public ScxHttpMethod method();

    public ScxURIWritable uri();

    public ScxHttpHeadersWritable headers();

    public ScxHttpClientRequest method(HttpMethod var1);

    public ScxHttpClientRequest uri(ScxURIWritable var1);

    public ScxHttpClientRequest headers(ScxHttpHeadersWritable var1);

    public ScxHttpClientResponse send(MediaWriter var1);

    default public ScxHttpClientRequest uri(String uri) {
        return this.uri(ScxURI.of(uri));
    }

    default public ScxHttpClientResponse send() {
        return this.send(new EmptyWriter());
    }

    default public ScxHttpClientResponse send(byte[] bytes) {
        return this.send(new ByteArrayWriter(bytes));
    }

    default public ScxHttpClientResponse send(String str) {
        return this.send(new StringWriter(str));
    }

    default public ScxHttpClientResponse send(String str, Charset charset) {
        return this.send(new StringWriter(str, charset));
    }

    default public ScxHttpClientResponse send(Path path) {
        return this.send(new PathWriter(path));
    }

    default public ScxHttpClientResponse send(Path path, long offset, long length) {
        return this.send(new PathWriter(path, offset, length));
    }

    default public ScxHttpClientResponse send(InputStream inputStream) {
        return this.send(new InputStreamWriter(inputStream));
    }

    default public ScxHttpClientResponse send(MultiPart multiPart) {
        return this.send(new MultiPartWriter(multiPart));
    }

    default public ScxHttpClientResponse send(Object object) {
        return this.send(new ObjectWriter(object));
    }

    default public ScxHttpClientRequest setHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest addHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest setHeader(String headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest addHeader(String headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest addCookie(Cookie ... cookie) {
        this.headers().addCookie(cookie);
        return this;
    }

    default public ScxHttpClientRequest removeCookie(String name) {
        this.headers().removeCookie(name);
        return this;
    }

    default public ContentType contentType() {
        return this.headers().contentType();
    }

    default public ScxHttpClientRequest contentType(ContentType contentType) {
        this.headers().contentType(contentType);
        return this;
    }

    default public Long contentLength() {
        return this.headers().contentLength();
    }

    default public ScxHttpClientRequest contentLength(long contentLength) {
        this.headers().contentLength(contentLength);
        return this;
    }
}

