/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media.multi_part.MultiPartPartWritable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.MultipartInput;

public class MultiPartStream
implements MultiPart,
Iterator<MultiPartPart> {
    private final MultipartInput multipartStream;
    private boolean hasNextPart;
    private String boundary;

    public MultiPartStream(InputStream inputStream, String boundary) {
        byte[] boundaryBytes = boundary.getBytes();
        try {
            this.multipartStream = ((MultipartInput.Builder)MultipartInput.builder().setInputStream(inputStream)).setBoundary(boundaryBytes).get();
            this.hasNextPart = this.multipartStream.skipPreamble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ScxHttpHeadersWritable readToHeaders(MultipartInput multipartStream) throws MultipartInput.MalformedStreamException, FileUploadSizeException {
        String headersStr = multipartStream.readHeaders();
        return ScxHttpHeaders.of(headersStr);
    }

    public static byte[] readContentToByte(MultipartInput multipartStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        multipartStream.readBodyData((OutputStream)output);
        return output.toByteArray();
    }

    @Override
    public String boundary() {
        return this.boundary;
    }

    @Override
    public Iterator<MultiPartPart> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNextPart;
    }

    @Override
    public MultiPartPart next() {
        if (!this.hasNextPart) {
            throw new NoSuchElementException("No more parts available.");
        }
        try {
            ScxHttpHeadersWritable headers = MultiPartStream.readToHeaders(this.multipartStream);
            MultiPartPartWritable part = new MultiPartPartImpl().headers(headers);
            byte[] content = MultiPartStream.readContentToByte(this.multipartStream);
            part.body(content);
            this.hasNextPart = this.multipartStream.readBoundary();
            return part;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading next part", e);
        }
    }
}

