/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.json_node;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.string.StringReader;
import java.io.InputStream;

public class JsonNodeReader
implements MediaReader<JsonNode> {
    public static final JsonNodeReader JSON_NODE_READER = new JsonNodeReader();

    @Override
    public JsonNode read(InputStream inputStream, ScxHttpHeaders requestHeaders) {
        ScxMediaType mediaType;
        String str = StringReader.STRING_READER.read(inputStream, requestHeaders);
        ContentType contentType = requestHeaders.contentType();
        ScxMediaType scxMediaType = mediaType = contentType != null ? contentType.mediaType() : null;
        if (MediaType.APPLICATION_JSON.equals(mediaType)) {
            try {
                return ObjectUtils.jsonMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException(e);
            }
        }
        if (MediaType.APPLICATION_XML.equals(mediaType)) {
            try {
                return ObjectUtils.xmlMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException(e);
            }
        }
        try {
            return ObjectUtils.jsonMapper().readTree(str);
        }
        catch (Exception exception) {
            try {
                return ObjectUtils.xmlMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException();
            }
        }
    }
}

