/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.common.util.RandomUtils;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media.multi_part.MultiPartPartWritable;
import cool.scx.http.media.multi_part.MultiPartStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.fileupload2.core.MultipartInput;

public class MultiPartStreamCached
implements MultiPart,
Iterator<MultiPartPart> {
    private final MultipartInput multipartStream;
    private final Path cachePath;
    private boolean hasNextPart;
    private String boundary;

    public MultiPartStreamCached(InputStream inputStream, String boundary, Path cachePath) {
        this.cachePath = cachePath;
        byte[] boundaryBytes = boundary.getBytes();
        try {
            this.multipartStream = ((MultipartInput.Builder)MultipartInput.builder().setInputStream(inputStream)).setBoundary(boundaryBytes).get();
            this.hasNextPart = this.multipartStream.skipPreamble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean needCached(ScxHttpHeaders headers) {
        ContentDisposition contentDisposition = headers.contentDisposition();
        if (contentDisposition == null) {
            return false;
        }
        String filename = contentDisposition.filename();
        return filename != null;
    }

    public static Path readContentToPath(MultipartInput multipartStream, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        OutputStream output = Files.newOutputStream(path, new OpenOption[0]);
        multipartStream.readBodyData(output);
        return path;
    }

    @Override
    public String boundary() {
        return this.boundary;
    }

    @Override
    public Iterator<MultiPartPart> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNextPart;
    }

    @Override
    public MultiPartPart next() {
        if (!this.hasNextPart) {
            throw new NoSuchElementException("No more parts available.");
        }
        try {
            ScxHttpHeadersWritable headers = MultiPartStream.readToHeaders(this.multipartStream);
            MultiPartPartWritable part = new MultiPartPartImpl().headers(headers);
            boolean b = MultiPartStreamCached.needCached(headers);
            if (b) {
                Path contentPath = MultiPartStreamCached.readContentToPath(this.multipartStream, this.cachePath.resolve(RandomUtils.randomString((int)32)));
                part.body(contentPath);
            } else {
                byte[] content = MultiPartStream.readContentToByte(this.multipartStream);
                part.body(content);
            }
            this.hasNextPart = this.multipartStream.readBoundary();
            return part;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading next part", e);
        }
    }
}

