/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.ScxHttpBody;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.content_type.ContentTypeWritable;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media.multi_part.MultiPartPartWritable;
import cool.scx.http.media.path.PathHelper;
import cool.scx.http.routing.handler.StaticHelper;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Supplier;

public interface MultiPartPart
extends ScxHttpBody {
    public static MultiPartPartWritable of() {
        return new MultiPartPartImpl();
    }

    public static MultiPartPartWritable of(String name, String value) {
        return new MultiPartPartImpl().name(name).body(value);
    }

    public static MultiPartPartWritable of(String name, byte[] value) {
        return new MultiPartPartImpl().name(name).body(value);
    }

    public static MultiPartPartWritable of(String name, Path value) {
        long fileSize = PathHelper.getFileSize(value);
        ContentTypeWritable contentType = StaticHelper.getMediaTypeByFile(value);
        String filename = value.getFileName().toString();
        return new MultiPartPartImpl().name(name).body(value).size(fileSize).filename(filename).contentType(contentType);
    }

    @Override
    public ScxHttpHeaders headers();

    public Supplier<InputStream> body();

    @Override
    default public InputStream inputStream() {
        return this.body().get();
    }

    @Override
    default public <T> T as(MediaReader<T> t) {
        return t.read(this.inputStream(), this.headers());
    }

    default public ContentType contentType() {
        return this.headers().contentType();
    }

    default public ContentDisposition contentDisposition() {
        return this.headers().contentDisposition();
    }

    default public String name() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.name() : null;
    }

    default public String filename() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.filename() : null;
    }

    default public Long size() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.size() : null;
    }
}

