/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.content_disposition;

import cool.scx.common.util.StringUtils;
import cool.scx.http.Parameters;
import cool.scx.http.ParametersWritable;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.content_disposition.ContentDispositionImpl;
import cool.scx.http.content_disposition.ContentDispositionWritable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContentDispositionHelper {
    public static ContentDispositionWritable decodedContentDisposition(String contentDispositionStr) {
        if (contentDispositionStr == null) {
            return null;
        }
        String[] split = contentDispositionStr.split(";\\s*");
        if (split.length == 0) {
            return null;
        }
        String type = split[0];
        ParametersWritable<String, String> params = Parameters.of();
        for (int i = 1; i < split.length; ++i) {
            String[] s = split[i].split("=", 2);
            if (s.length != 2) continue;
            params.add(s[0], (String[])new String[]{StringUtils.removeQuotes((String)s[1])});
        }
        return new ContentDispositionImpl().type(type).params(params);
    }

    public static String encodeContentDisposition(ContentDisposition contentType) {
        StringBuilder sb = new StringBuilder();
        String type = contentType.type();
        Parameters<String, String> params = contentType.params();
        sb.append(type);
        if (contentType.params() != null && !contentType.params().isEmpty()) {
            sb.append("; ");
            sb.append(ContentDispositionHelper.encodeParams(params));
        }
        return sb.toString();
    }

    public static String encodeParams(Parameters<String, String> params) {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        for (Map.Entry entry : params) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            for (String s : value) {
                l.add((CallSite)((Object)(key + "=" + s)));
            }
        }
        return String.join((CharSequence)";", l);
    }
}

