/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.content_type;

import cool.scx.http.Parameters;
import cool.scx.http.ParametersWritable;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentTypeImpl;
import cool.scx.http.content_type.ContentTypeWritable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContentTypeHelper {
    public static ContentTypeWritable decodedContentType(String contentTypeStr) {
        if (contentTypeStr == null) {
            return null;
        }
        String[] split = contentTypeStr.split(";\\s*");
        if (split.length == 0) {
            return null;
        }
        ScxMediaType mediaType = ScxMediaType.of(split[0]);
        ParametersWritable<String, String> params = Parameters.of();
        for (int i = 1; i < split.length; ++i) {
            String[] s = split[i].split("=", 2);
            if (s.length != 2) continue;
            params.add(s[0], (String[])new String[]{s[1]});
        }
        return new ContentTypeImpl().mediaType(mediaType).params(params);
    }

    public static String encodeContentType(ContentTypeImpl contentType) {
        StringBuilder sb = new StringBuilder();
        ScxMediaType mediaType = contentType.mediaType();
        Parameters params = contentType.params();
        sb.append(mediaType.value());
        if (contentType.params() != null && !contentType.params().isEmpty()) {
            sb.append("; ");
            sb.append(ContentTypeHelper.encodeParams(params));
        }
        return sb.toString();
    }

    public static String encodeParams(Parameters<String, String> params) {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        for (Map.Entry entry : params) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            for (String s : value) {
                l.add((CallSite)((Object)(key + "=" + s)));
            }
        }
        return String.join((CharSequence)";", l);
    }
}

