/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.MediaType;
import java.util.Map;
import java.util.TreeMap;

public enum FileFormat {
    TXT(MediaType.TEXT_PLAIN),
    HTML(MediaType.TEXT_HTML),
    CSS(MediaType.TEXT_CSS),
    JS(MediaType.TEXT_JS),
    BIN(MediaType.APPLICATION_OCTET_STREAM),
    XML(MediaType.APPLICATION_XML),
    JSON(MediaType.APPLICATION_JSON),
    ZIP(MediaType.APPLICATION_ZIP),
    PDF(MediaType.APPLICATION_PDF),
    DOC(MediaType.APPLICATION_DOC),
    XLS(MediaType.APPLICATION_XLS),
    PPT(MediaType.APPLICATION_PPT),
    DOCX(MediaType.APPLICATION_DOCX),
    XLSX(MediaType.APPLICATION_XLSX),
    PPTX(MediaType.APPLICATION_PPTX),
    APK(MediaType.APPLICATION_APK),
    BMP(MediaType.IMAGE_BMP),
    PNG(MediaType.IMAGE_PNG),
    JPG(MediaType.IMAGE_JPEG),
    JPEG(MediaType.IMAGE_JPEG),
    GIF(MediaType.IMAGE_GIF),
    SVG(MediaType.IMAGE_SVG),
    WEBP(MediaType.IMAGE_WEBP),
    MP3(MediaType.AUDIO_MPEG),
    WAV(MediaType.AUDIO_WAV),
    MP4(MediaType.VIDEO_MP4),
    WEBM(MediaType.VIDEO_WEBM);

    private static final Map<String, FileFormat> MAP;
    private final MediaType mediaType;

    private FileFormat(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    private static Map<String, FileFormat> initMAP() {
        TreeMap<String, FileFormat> map = new TreeMap<String, FileFormat>(String.CASE_INSENSITIVE_ORDER);
        for (FileFormat value : FileFormat.values()) {
            map.put(value.name(), value);
        }
        return map;
    }

    public static FileFormat findByExtension(String ext) {
        return MAP.get(ext);
    }

    public static FileFormat findByFileName(String filename) {
        int li = filename.lastIndexOf(46);
        if (li != -1 && li != filename.length() - 1) {
            String ext = filename.substring(li + 1);
            return FileFormat.findByExtension(ext);
        }
        return null;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    static {
        MAP = FileFormat.initMAP();
    }
}

