/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.content_disposition;

import cool.scx.common.util.StringUtils;
import cool.scx.http.Parameters;
import cool.scx.http.ParametersWritable;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.content_disposition.ContentDispositionImpl;
import cool.scx.http.content_disposition.ContentDispositionWritable;
import cool.scx.http.content_type.ContentTypeHelper;

public class ContentDispositionHelper {
    public static ContentDispositionWritable decodedContentDisposition(String contentDispositionStr) {
        if (contentDispositionStr == null) {
            return null;
        }
        String[] split = contentDispositionStr.split(";\\s*");
        if (split.length == 0) {
            return null;
        }
        String type = split[0];
        ParametersWritable<String, String> params = Parameters.of();
        for (int i = 1; i < split.length; ++i) {
            String[] s = split[i].split("=", 2);
            if (s.length != 2) continue;
            params.add(s[0], (String[])new String[]{StringUtils.removeQuotes((String)s[1])});
        }
        return new ContentDispositionImpl().type(type).params(params);
    }

    public static String encodeContentDisposition(ContentDisposition contentDisposition) {
        String type = contentDisposition.type();
        Parameters<String, String> params = contentDisposition.params();
        StringBuilder sb = new StringBuilder(type);
        if (params != null) {
            ContentTypeHelper.encodeParams(sb, params);
        }
        return sb.toString();
    }
}

