/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.content_type;

import cool.scx.http.Parameters;
import cool.scx.http.ParametersWritable;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentTypeImpl;
import cool.scx.http.content_type.ContentTypeWritable;
import java.util.List;
import java.util.Map;

public class ContentTypeHelper {
    public static ContentTypeWritable decodedContentType(String contentTypeStr) {
        if (contentTypeStr == null) {
            return null;
        }
        String[] split = contentTypeStr.split(";\\s*");
        if (split.length == 0) {
            return null;
        }
        ScxMediaType mediaType = ScxMediaType.of(split[0]);
        ParametersWritable<String, String> params = Parameters.of();
        for (int i = 1; i < split.length; ++i) {
            String[] s = split[i].split("=", 2);
            if (s.length != 2) continue;
            params.add(s[0], (String[])new String[]{s[1]});
        }
        return new ContentTypeImpl().mediaType(mediaType).params(params);
    }

    public static String encodeContentType(ContentTypeImpl contentType) {
        ScxMediaType mediaType = contentType.mediaType();
        Parameters params = contentType.params();
        StringBuilder sb = new StringBuilder(mediaType.value());
        if (params != null) {
            ContentTypeHelper.encodeParams(sb, params);
        }
        return sb.toString();
    }

    public static void encodeParams(StringBuilder result, Parameters<String, String> params) {
        for (Map.Entry entry : params) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                result.append("; ").append(key).append("=").append(value);
            }
        }
    }
}

