/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.path;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathHelper {
    public static long getFileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fileCopy(Path path, OutputStream out) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             OutputStream outputStream = out;){
            inputStream.transferTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fileCopyWithOffset(Path path, OutputStream out, long offset, long length) {
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");
             OutputStream outputStream = out;){
            raf.seek(offset);
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int i = raf.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                if (i == -1) {
                    break;
                }
                out.write(buffer, 0, i);
                length -= (long)i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

