/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.form_params;

import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class FormParamsWriter
implements MediaWriter {
    private final FormParams formParams;
    private final byte[] bytes;

    public FormParamsWriter(FormParams formParams) {
        this.formParams = formParams;
        this.bytes = FormParamsHelper.encodeFormParams(formParams).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable headersWritable, ScxHttpHeaders headers) {
        if (headersWritable.contentLength() == null) {
            headersWritable.contentLength(this.bytes.length);
        }
        if (headersWritable.contentType() == null) {
            headersWritable.contentType(ContentType.of(MediaType.APPLICATION_X_WWW_FORM_URLENCODED));
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

