/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.ScxClientWebSocket;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.cookie.Cookie;
import cool.scx.http.uri.ScxURI;
import java.util.function.Consumer;

public interface ScxClientWebSocketBuilder {
    public ScxURI uri();

    public ScxClientWebSocketBuilder uri(ScxURI var1);

    public ScxHttpHeadersWritable headers();

    public ScxClientWebSocketBuilder headers(ScxHttpHeadersWritable var1);

    public ScxClientWebSocketBuilder onConnect(Consumer<ScxClientWebSocket> var1);

    public void connect();

    default public ScxClientWebSocketBuilder uri(String uri) {
        return this.uri(ScxURI.of(uri));
    }

    default public ScxClientWebSocketBuilder setHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxClientWebSocketBuilder addHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxClientWebSocketBuilder setHeader(String headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxClientWebSocketBuilder addHeader(String headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxClientWebSocketBuilder addCookie(Cookie ... cookie) {
        this.headers().addCookie(cookie);
        return this;
    }

    default public ScxClientWebSocketBuilder removeCookie(String name) {
        this.headers().removeCookie(name);
        return this;
    }
}

