/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.common.util.Base64Utils;
import cool.scx.common.util.HashUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.http.FileFormat;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpServerRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class HttpHelper {
    public static String getRequestIP(ScxHttpServerRequest request) {
        String[] s;
        String xRealIPStr = request.getHeader("X-Real-IP");
        if (StringUtils.notBlank((String)xRealIPStr) && !"unknown".equalsIgnoreCase(xRealIPStr)) {
            return xRealIPStr;
        }
        String xForwardedForStr = request.getHeader("X-Forwarded-For");
        if (StringUtils.notBlank((String)xForwardedForStr) && !"unknown".equalsIgnoreCase(xForwardedForStr) && (s = xForwardedForStr.split(",")).length > 0) {
            return s[0];
        }
        String remoteAddressStr = request.remotePeer().address().toString();
        if ("0:0:0:0:0:0:0:1".equals(remoteAddressStr)) {
            return "127.0.0.1";
        }
        return remoteAddressStr;
    }

    public static String getDownloadContentDisposition(String downloadName) {
        return "attachment; filename*=utf-8''" + URLEncoder.encode(downloadName, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static MediaType getMediaTypeByExtension(String ext) {
        FileFormat fileFormat = FileFormat.findByExtension(ext);
        return fileFormat != null ? fileFormat.mediaType() : null;
    }

    public static MediaType getMediaTypeByFileName(String filename) {
        FileFormat fileFormat = FileFormat.findByFileName(filename);
        return fileFormat != null ? fileFormat.mediaType() : null;
    }

    public static String generateSecWebSocketAccept(String key) {
        return Base64Utils.encodeToString((byte[])HashUtils.sha1((String)(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")));
    }
}

