/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.common.util.RandomUtils;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media.multi_part.MultiPartStream;
import cool.scx.io.NoMatchFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;

public class MultiPartStreamCached
extends MultiPartStream {
    private final Path cachePath;

    public MultiPartStreamCached(InputStream inputStream, String boundary, Path cachePath) {
        super(inputStream, boundary);
        this.cachePath = cachePath;
    }

    public static boolean needCached(ScxHttpHeaders headers) {
        ContentDisposition contentDisposition = headers.contentDisposition();
        if (contentDisposition == null) {
            return false;
        }
        String filename = contentDisposition.filename();
        return filename != null;
    }

    public Path readContentToPath(Path path) throws IOException {
        OutputStream output;
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = output = Files.newOutputStream(path, new OpenOption[0]);){
            try {
                int i = this.linkedDataReader.indexOf(this.boundaryBytes);
                this.linkedDataReader.read((b, off, len) -> {
                    try {
                        output.write(b, off, len);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }, i - 2);
                this.linkedDataReader.skip(2);
            }
            catch (NoMatchFoundException e) {
                throw new RuntimeException("\u5f02\u5e38\u72b6\u6001 !!!");
            }
        }
        return path;
    }

    @Override
    public MultiPartPart next() {
        if (!this.hasNextPart) {
            throw new NoSuchElementException("No more parts available.");
        }
        try {
            MultiPartPartImpl part = new MultiPartPartImpl();
            ScxHttpHeadersWritable headers = this.readToHeaders();
            part.headers(headers);
            boolean b = MultiPartStreamCached.needCached(headers);
            if (b) {
                Path contentPath = this.readContentToPath(this.cachePath.resolve(RandomUtils.randomString((int)32)));
                part.body(contentPath);
            } else {
                byte[] content = this.readContentToByte();
                part.body(content);
            }
            this.hasNextPart = this.readNext();
            return part;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading next part", e);
        }
    }
}

