/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

public enum HttpVersion {
    HTTP_1_0("HTTP/1.0"),
    HTTP_1_1("HTTP/1.1"),
    HTTP_2("HTTP/2.0");

    private final String value;

    private HttpVersion(String value) {
        this.value = value;
    }

    public static HttpVersion of(String version) {
        String upperCase;
        return switch (upperCase = version.toUpperCase()) {
            case "HTTP/1.0" -> HTTP_1_0;
            case "HTTP/1.1" -> HTTP_1_1;
            case "HTTP/2.0" -> HTTP_2;
            default -> throw new IllegalArgumentException("Unsupported HTTP version: " + version);
        };
    }

    public static HttpVersion find(String version) {
        String upperCase;
        return switch (upperCase = version.toUpperCase()) {
            case "HTTP/1.0" -> HTTP_1_0;
            case "HTTP/1.1" -> HTTP_1_1;
            case "HTTP/2.0" -> HTTP_2;
            default -> null;
        };
    }

    public String value() {
        return this.value;
    }
}

