/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersImpl;
import cool.scx.http.ScxHttpHeadersWritable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ScxHttpHeadersHelper {
    public static final Pattern CRLF_PATTERN = Pattern.compile("\r\n");

    public static ScxHttpHeadersWritable parseHeaders(String headersStr) {
        String[] lines;
        ScxHttpHeadersImpl headers = new ScxHttpHeadersImpl();
        for (String line : lines = CRLF_PATTERN.split(headersStr)) {
            int i = line.indexOf(58);
            if (i == -1) continue;
            String key = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            headers.add(key, value);
        }
        return headers;
    }

    public static String encodeHeaders(ScxHttpHeaders headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry header : headers) {
            ScxHttpHeaderName key = (ScxHttpHeaderName)header.getKey();
            List values = (List)header.getValue();
            for (String value : values) {
                sb.append(key.value()).append(": ").append(value).append("\r\n");
            }
        }
        return sb.toString();
    }
}

