/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.content_disposition.ContentDispositionWritable;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.media.multi_part.MultiPartPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;

public interface MultiPartPartWritable
extends MultiPartPart {
    @Override
    public ScxHttpHeadersWritable headers();

    public MultiPartPartWritable headers(ScxHttpHeaders var1);

    public MultiPartPartWritable body(Supplier<InputStream> var1);

    default public MultiPartPartWritable contentType(ContentType contentType) {
        this.headers().contentType(contentType);
        return this;
    }

    default public MultiPartPartWritable contentDisposition(ContentDisposition contentDisposition) {
        this.headers().contentDisposition(contentDisposition);
        return this;
    }

    default public MultiPartPartWritable name(String name) {
        ContentDispositionWritable contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            contentDisposition.name(name);
            this.contentDisposition(contentDisposition);
        } else {
            this.contentDisposition(ContentDisposition.of().type("form-data").name(name));
        }
        return this;
    }

    default public MultiPartPartWritable filename(String filename) {
        ContentDispositionWritable contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            contentDisposition.filename(filename);
            this.contentDisposition(contentDisposition);
        } else {
            this.contentDisposition(ContentDisposition.of().type("form-data").filename(filename));
        }
        return this;
    }

    default public MultiPartPartWritable size(long size) {
        ContentDispositionWritable contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            contentDisposition.size(size);
            this.contentDisposition(contentDisposition);
        } else {
            this.contentDisposition(ContentDisposition.of().type("form-data").size(size));
        }
        return this;
    }

    default public MultiPartPartWritable body(InputStream os) {
        return this.body(() -> os);
    }

    default public MultiPartPartWritable body(byte[] os) {
        return this.body(() -> new ByteArrayInputStream(os));
    }

    default public MultiPartPartWritable body(String os) {
        return this.body(() -> new ByteArrayInputStream(os.getBytes()));
    }

    default public MultiPartPartWritable body(Path os) {
        return this.body(() -> {
            try {
                return Files.newInputStream(os, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

