/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.web_socket;

import cool.scx.http.web_socket.ScxWebSocketCloseInfo;
import cool.scx.http.web_socket.ScxWebSocketCloseInfoImpl;
import cool.scx.http.web_socket.WebSocketFrame;
import cool.scx.http.web_socket.WebSocketOpCode;
import cool.scx.io.DataReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class WebSocketFrameHelper {
    public static WebSocketFrame readFrame(DataReader reader) {
        byte[] header = reader.read(2);
        byte b1 = header[0];
        boolean fin = (b1 & 0x80) != 0;
        boolean rsv1 = (b1 & 0x40) != 0;
        boolean rsv2 = (b1 & 0x20) != 0;
        boolean rsv3 = (b1 & 0x10) != 0;
        WebSocketOpCode opCode = WebSocketOpCode.of(b1 & 0xF);
        byte b2 = header[1];
        boolean masked = (b2 & 0x80) != 0;
        int payloadLength = b2 & 0x7F;
        if (payloadLength == 126) {
            extendedPayloadLength = reader.read(2);
            payloadLength = (extendedPayloadLength[0] & 0xFF) << 8 | extendedPayloadLength[1] & 0xFF;
        } else if (payloadLength == 127) {
            extendedPayloadLength = reader.read(8);
            payloadLength = (int)(((long)extendedPayloadLength[0] & 0xFFL) << 56 | ((long)extendedPayloadLength[1] & 0xFFL) << 48 | ((long)extendedPayloadLength[2] & 0xFFL) << 40 | ((long)extendedPayloadLength[3] & 0xFFL) << 32 | (long)((extendedPayloadLength[4] & 0xFF) << 24) | (long)((extendedPayloadLength[5] & 0xFF) << 16) | (long)((extendedPayloadLength[6] & 0xFF) << 8) | (long)(extendedPayloadLength[7] & 0xFF));
        }
        byte[] maskingKey = null;
        if (masked) {
            maskingKey = reader.read(4);
        }
        byte[] payloadData = reader.read(payloadLength);
        if (masked) {
            for (int i = 0; i < payloadLength; ++i) {
                payloadData[i] = (byte)(payloadData[i] ^ maskingKey[i % 4]);
            }
        }
        return new WebSocketFrame(fin, rsv1, rsv2, rsv3, opCode, masked, payloadLength, maskingKey, payloadData);
    }

    public static void writeFrame(WebSocketFrame frame, OutputStream out) throws IOException {
        int masked;
        int fullOpCode = (frame.fin() ? 128 : 0) | (frame.rsv1() ? 64 : 0) | (frame.rsv2() ? 32 : 0) | (frame.rsv3() ? 16 : 0) | frame.opCode().code();
        out.write(fullOpCode);
        int length = frame.payloadLength();
        int n = masked = frame.masked() ? 128 : 0;
        if ((long)length < 126L) {
            out.write(length | masked);
        } else if ((long)length < 65536L) {
            out.write(0x7E | masked);
            out.write(length >>> 8 & 0xFF);
            out.write(length & 0xFF);
        } else {
            out.write(0x7F | masked);
            for (int i = 56; i >= 0; i -= 8) {
                out.write(length >>> i & 0xFF);
            }
        }
        if (frame.masked()) {
            byte[] maskingKey = frame.maskingKey();
            out.write(maskingKey);
        }
        byte[] payloadData = frame.payloadData();
        byte[] maskingKey = frame.maskingKey();
        if (frame.masked()) {
            for (int i = 0; i < payloadData.length; ++i) {
                payloadData[i] = (byte)(payloadData[i] ^ maskingKey[i % 4]);
            }
        }
        out.write(payloadData);
        out.flush();
    }

    public static WebSocketFrame readFrameUntilLast(DataReader reader) {
        WebSocketFrame webSocketFrame;
        ArrayList<WebSocketFrame> frameList = new ArrayList<WebSocketFrame>();
        do {
            webSocketFrame = WebSocketFrameHelper.readFrame(reader);
            frameList.add(webSocketFrame);
        } while (!webSocketFrame.fin());
        WebSocketFrame first = (WebSocketFrame)frameList.get(0);
        if (frameList.size() == 1) {
            return first;
        }
        WebSocketOpCode opCode = first.opCode();
        int length = frameList.stream().mapToInt(WebSocketFrame::payloadLength).sum();
        byte[] payloadData = new byte[length];
        int offset = 0;
        for (WebSocketFrame webSocketFrame2 : frameList) {
            System.arraycopy(webSocketFrame2.payloadData(), 0, payloadData, offset, webSocketFrame2.payloadLength());
            offset += webSocketFrame2.payloadLength();
        }
        return WebSocketFrame.of(true, opCode, payloadData);
    }

    public static ScxWebSocketCloseInfoImpl parseCloseInfo(byte[] frame) {
        int len = frame.length;
        int code = 1005;
        if (len >= 2) {
            code = (frame[0] & 0xFF) << 8 | frame[1] & 0xFF;
        }
        String reason = null;
        if (len > 2) {
            reason = new String(frame, 2, len - 2);
        }
        return new ScxWebSocketCloseInfoImpl(code, reason);
    }

    public static byte[] createClosePayload(ScxWebSocketCloseInfo closeInfo) {
        int code = closeInfo.code();
        String reason = closeInfo.reason();
        byte[] reasonBytes = reason != null ? reason.getBytes() : new byte[]{};
        byte[] payload = new byte[2 + reasonBytes.length];
        payload[0] = (byte)(code >> 8);
        payload[1] = (byte)(code & 0xFF);
        System.arraycopy(reasonBytes, 0, payload, 2, reasonBytes.length);
        return payload;
    }
}

