/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.accept;

import cool.scx.http.ScxMediaType;
import cool.scx.http.accept.AcceptImpl;
import cool.scx.http.accept.AcceptWritable;
import cool.scx.http.accept.AcceptsImpl;
import cool.scx.http.accept.AcceptsWritable;

public class AcceptHelper {
    public static AcceptWritable decodeAccept(String s) {
        String[] parts = s.split(";");
        String type = parts[0].trim();
        double weight = 1.0;
        if (parts.length > 1) {
            for (String part : parts) {
                if (!(part = part.trim()).startsWith("q=")) continue;
                try {
                    weight = Double.parseDouble(part.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new AcceptImpl().mediaType(ScxMediaType.of(type)).q(weight);
    }

    public static AcceptsWritable decodeAccepts(String s) {
        String[] mediaTypes;
        if (s == null) {
            return null;
        }
        AcceptsImpl writable = new AcceptsImpl();
        for (String mediaType : mediaTypes = s.split(",")) {
            AcceptWritable a = AcceptHelper.decodeAccept(mediaType);
            writable.add(a);
        }
        return writable;
    }
}

