/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.web_socket;

public enum WebSocketOpCode {
    CONTINUATION(0),
    TEXT(1),
    BINARY(2),
    CLOSE(8),
    PING(9),
    PONG(10);

    private static final WebSocketOpCode[] MAP;
    private final int code;

    private WebSocketOpCode(int code) {
        this.code = code;
    }

    private static WebSocketOpCode[] initMap() {
        WebSocketOpCode[] values;
        WebSocketOpCode[] m = new WebSocketOpCode[11];
        WebSocketOpCode[] webSocketOpCodeArray = values = WebSocketOpCode.values();
        int n = webSocketOpCodeArray.length;
        for (int i = 0; i < n; ++i) {
            WebSocketOpCode v;
            m[v.code] = v = webSocketOpCodeArray[i];
        }
        return m;
    }

    public static WebSocketOpCode of(int code) {
        if (code < 0 || code > 10) {
            throw new IllegalArgumentException("Invalid WebSocket OpCode: " + code);
        }
        WebSocketOpCode c = MAP[code];
        if (c == null) {
            throw new IllegalArgumentException("Invalid WebSocket OpCode: " + code);
        }
        return c;
    }

    public static WebSocketOpCode find(int code) {
        if (code < 0 || code > 10) {
            return null;
        }
        return MAP[code];
    }

    public int code() {
        return this.code;
    }

    static {
        MAP = WebSocketOpCode.initMap();
    }
}

