/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.content_type;

import cool.scx.http.Parameters;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentTypeHelper;
import cool.scx.http.content_type.ContentTypeImpl;
import cool.scx.http.content_type.ContentTypeWritable;
import java.nio.charset.Charset;

public interface ContentType {
    public static ContentTypeWritable of() {
        return new ContentTypeImpl();
    }

    public static ContentTypeWritable of(String contentTypeStr) {
        return ContentTypeHelper.decodedContentType(contentTypeStr);
    }

    public static ContentTypeWritable of(ScxMediaType mediaType) {
        return new ContentTypeImpl().mediaType(mediaType);
    }

    public static ContentTypeWritable of(ContentType oldContentType) {
        return new ContentTypeImpl(oldContentType);
    }

    public ScxMediaType mediaType();

    public Parameters<String, String> params();

    default public Charset charset() {
        String charset = this.params().get("charset");
        return charset == null ? null : Charset.forName(charset);
    }

    default public String boundary() {
        return this.params().get("boundary");
    }

    public String encode();
}

