/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.web_socket;

import cool.scx.http.web_socket.WebSocketCloseInfo;
import cool.scx.http.web_socket.handler.BinaryMessageHandler;
import cool.scx.http.web_socket.handler.CloseHandler;
import cool.scx.http.web_socket.handler.TextMessageHandler;
import java.util.function.Consumer;

public interface ScxWebSocket {
    public ScxWebSocket onTextMessage(TextMessageHandler var1);

    public ScxWebSocket onBinaryMessage(BinaryMessageHandler var1);

    public ScxWebSocket onPing(Consumer<byte[]> var1);

    public ScxWebSocket onPong(Consumer<byte[]> var1);

    public ScxWebSocket onClose(CloseHandler var1);

    public ScxWebSocket onError(Consumer<Throwable> var1);

    public ScxWebSocket send(String var1, boolean var2);

    public ScxWebSocket send(byte[] var1, boolean var2);

    public ScxWebSocket ping(byte[] var1);

    public ScxWebSocket pong(byte[] var1);

    public ScxWebSocket close(int var1, String var2);

    public ScxWebSocket terminate();

    public boolean isClosed();

    default public ScxWebSocket send(String textMessage) {
        return this.send(textMessage, true);
    }

    default public ScxWebSocket send(byte[] binaryMessage) {
        return this.send(binaryMessage, true);
    }

    default public ScxWebSocket close(WebSocketCloseInfo closeInfo) {
        return this.close(closeInfo.code(), closeInfo.reason());
    }

    default public ScxWebSocket close() {
        return this.close(WebSocketCloseInfo.NORMAL_CLOSE);
    }
}

