/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.json_node;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.accept.Accept;
import cool.scx.http.accept.Accepts;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.content_type.ContentTypeWritable;
import cool.scx.http.media.MediaWriter;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JsonNodeWriter
implements MediaWriter {
    private final JsonNode jsonNode;
    private byte[] data;

    public JsonNodeWriter(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        this.data = null;
    }

    public static ContentTypeWritable trySetContentType(ScxHttpHeadersWritable headersWritable, ScxHttpHeaders headers) {
        if (headersWritable.contentType() != null) {
            return headersWritable.contentType();
        }
        Accepts accepts = headers.accepts();
        if (accepts == null) {
            headersWritable.contentType(ContentType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8));
            return headersWritable.contentType();
        }
        for (Accept accept : accepts) {
            if (accept.mediaType() == MediaType.APPLICATION_XML) {
                headersWritable.contentType(ContentType.of(MediaType.APPLICATION_XML).charset(StandardCharsets.UTF_8));
                return headersWritable.contentType();
            }
            if (accept.mediaType() != MediaType.APPLICATION_JSON) continue;
            headersWritable.contentType(ContentType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8));
            return headersWritable.contentType();
        }
        headersWritable.contentType(ContentType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8));
        return headersWritable.contentType();
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block5: {
            ContentTypeWritable contentType = JsonNodeWriter.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (contentType.mediaType() == MediaType.APPLICATION_JSON) {
                    this.data = ObjectUtils.jsonMapper().writeValueAsBytes((Object)this.jsonNode);
                    break block5;
                }
                if (contentType.mediaType() == MediaType.APPLICATION_XML) {
                    this.data = ObjectUtils.xmlMapper().writeValueAsBytes((Object)this.jsonNode);
                    break block5;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType.mediaType()));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        if (responseHeaders.contentLength() == null) {
            responseHeaders.contentLength(this.data.length);
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

