/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.io.DataSupplier;
import cool.scx.io.InputStreamDataSupplier;
import cool.scx.io.LinkedDataReader;
import cool.scx.io.NoMatchFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiPartStream
implements MultiPart,
Iterator<MultiPartPart> {
    protected static final byte[] CRLF_CRLF_BYTES = "\r\n\r\n".getBytes();
    protected final LinkedDataReader linkedDataReader;
    protected final byte[] boundaryBytes;
    protected boolean hasNextPart;
    protected String boundary;

    public MultiPartStream(InputStream inputStream, String boundary) {
        this.boundaryBytes = ("--" + boundary).getBytes();
        this.linkedDataReader = new LinkedDataReader((DataSupplier)new InputStreamDataSupplier(inputStream));
        this.hasNextPart = this.readNext();
    }

    public ScxHttpHeadersWritable readToHeaders() {
        byte[] headersBytes = this.linkedDataReader.readUntil(CRLF_CRLF_BYTES);
        String headersStr = new String(headersBytes);
        return ScxHttpHeaders.of(headersStr);
    }

    public byte[] readContentToByte() throws IOException {
        try {
            long i = this.linkedDataReader.indexOf(this.boundaryBytes);
            byte[] bytes = this.linkedDataReader.read((int)(i - 2L));
            this.linkedDataReader.skip(2L);
            return bytes;
        }
        catch (NoMatchFoundException e) {
            throw new RuntimeException("\u5f02\u5e38\u72b6\u6001 !!!");
        }
    }

    public boolean readNext() {
        try {
            long i = this.linkedDataReader.indexOf(this.boundaryBytes);
            this.linkedDataReader.skip(i + (long)this.boundaryBytes.length);
            byte a = this.linkedDataReader.read();
            byte b = this.linkedDataReader.read();
            if (a == 13 && b == 10) {
                return true;
            }
            if (a == 45 && b == 45) {
                return false;
            }
            throw new RuntimeException("\u672a\u77e5\u5b57\u7b26 !!! ");
        }
        catch (NoMatchFoundException e) {
            return false;
        }
    }

    @Override
    public String boundary() {
        return this.boundary;
    }

    @Override
    public Iterator<MultiPartPart> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNextPart;
    }

    @Override
    public MultiPartPart next() {
        if (!this.hasNextPart) {
            throw new NoSuchElementException("No more parts available.");
        }
        try {
            MultiPartPartImpl part = new MultiPartPartImpl();
            ScxHttpHeadersWritable headers = this.readToHeaders();
            part.headers(headers);
            byte[] content = this.readContentToByte();
            part.body(content);
            this.hasNextPart = this.readNext();
            return part;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading next part", e);
        }
    }
}

