/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.HttpMethod;
import cool.scx.http.routing.MethodMatcher;
import cool.scx.http.routing.PathMatcher;
import cool.scx.http.routing.RouteWritable;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.TypeMatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

class RouteImpl
implements RouteWritable {
    private String path = null;
    private Set<HttpMethod> methods = new HashSet<HttpMethod>();
    private TypeMatcher typeMatcher = TypeMatcher.any();
    private PathMatcher pathMatcher = PathMatcher.any();
    private MethodMatcher methodMatcher = MethodMatcher.any();
    private int order = 0;
    private Consumer<RoutingContext> handler = RoutingContext::next;

    @Override
    public RouteWritable type(TypeMatcher.Type type) {
        this.typeMatcher = TypeMatcher.of(type);
        return this;
    }

    @Override
    public RouteImpl path(String path) {
        this.path = path;
        this.pathMatcher = PathMatcher.of(path);
        return this;
    }

    @Override
    public RouteImpl pathRegex(String path) {
        this.path = path;
        this.pathMatcher = PathMatcher.ofRegex(path);
        return this;
    }

    @Override
    public RouteImpl method(HttpMethod ... httpMethods) {
        this.methods = Set.of(httpMethods);
        this.methodMatcher = MethodMatcher.of(httpMethods);
        return this;
    }

    @Override
    public RouteImpl order(int order) {
        this.order = order;
        return this;
    }

    @Override
    public RouteImpl handler(Consumer<RoutingContext> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Set<HttpMethod> methods() {
        return this.methods;
    }

    @Override
    public TypeMatcher typeMatcher() {
        return this.typeMatcher;
    }

    @Override
    public PathMatcher pathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public MethodMatcher methodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public Consumer<RoutingContext> handler() {
        return this.handler;
    }
}

