/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.HttpStatusCode;
import cool.scx.http.Parameters;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.exception.MethodNotAllowedException;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.exception.ScxHttpException;
import cool.scx.http.routing.PathMatcher;
import cool.scx.http.routing.Route;
import cool.scx.http.routing.RouterImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RoutingContext {
    private final RouterImpl router;
    private final ScxHttpServerRequest request;
    private final Iterator<Route> iter;
    private final Map<String, Object> contentParams;
    private Parameters<String, String> nowPathParams;

    RoutingContext(RouterImpl router, ScxHttpServerRequest request) {
        this.router = router;
        this.request = request;
        this.iter = router.routes.iterator();
        this.contentParams = new HashMap<String, Object>();
    }

    public <T extends ScxHttpServerRequest> T request() {
        return (T)this.request;
    }

    public <T extends ScxHttpServerResponse> T response() {
        return (T)this.request.response();
    }

    public final void next() {
        try {
            this.tryNext();
        }
        catch (Throwable e) {
            if (this.router.errorHandler != null) {
                this.router.errorHandler.accept(e, this);
            }
            if (e instanceof ScxHttpException) {
                ScxHttpException httpException = (ScxHttpException)e;
                HttpStatusCode code = httpException.statusCode();
                this.response().status(code).send(code.toString());
            }
            this.response().status(HttpStatusCode.INTERNAL_SERVER_ERROR).send("Internal Server Error");
        }
    }

    void tryNext() throws Throwable {
        ScxHttpException e = new NotFoundException();
        while (this.iter.hasNext()) {
            Route routeState = this.iter.next();
            boolean typeMatcherResult = routeState.typeMatcher().matches(this.request);
            if (!typeMatcherResult) continue;
            PathMatcher.MatchResult pathMatchResult = routeState.pathMatcher().matches(this.request.path());
            this.nowPathParams = pathMatchResult.pathParams();
            if (!pathMatchResult.accepted()) continue;
            boolean methodMatchResult = routeState.methodMatcher().matches(this.request.method());
            if (!methodMatchResult) {
                e = new MethodNotAllowedException();
                continue;
            }
            routeState.handler().accept(this);
            return;
        }
        throw e;
    }

    public Parameters<String, String> pathParams() {
        return this.nowPathParams;
    }

    public <T> T get(String name) {
        return (T)this.contentParams.get(name);
    }

    public RoutingContext put(String name, Object value) {
        this.contentParams.put(name, value);
        return this;
    }
}

