/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing.handler;

import cool.scx.http.HttpFieldName;
import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpMethod;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.exception.ForbiddenException;
import cool.scx.http.routing.RoutingContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class CorsHandler
implements Consumer<RoutingContext> {
    private final Set<String> allowedMethods = new LinkedHashSet<String>();
    private final Set<String> allowedHeaders = new LinkedHashSet<String>();
    private final Set<String> exposedHeaders = new LinkedHashSet<String>();
    private Set<String> origins = null;
    private String allowedMethodsString;
    private String allowedHeadersString;
    private String exposedHeadersString;
    private boolean allowCredentials;
    private String maxAgeSeconds;

    private boolean starOrigin() {
        return this.origins == null;
    }

    public CorsHandler addOrigin(String origin) {
        Objects.requireNonNull(origin, "'origin' cannot be null");
        if (origin.equals("*")) {
            this.origins = null;
            return this;
        }
        if (this.origins == null) {
            this.origins = new LinkedHashSet<String>();
        }
        this.origins.add(origin);
        return this;
    }

    public CorsHandler allowedMethod(String ... methods) {
        Collections.addAll(this.allowedMethods, methods);
        this.allowedMethodsString = String.join((CharSequence)",", this.allowedMethods);
        return this;
    }

    public CorsHandler allowedHeader(String ... headerNames) {
        Collections.addAll(this.allowedHeaders, headerNames);
        this.allowedHeadersString = String.join((CharSequence)",", this.allowedHeaders);
        return this;
    }

    public CorsHandler exposedHeader(String ... headerNames) {
        Collections.addAll(this.exposedHeaders, headerNames);
        this.exposedHeadersString = String.join((CharSequence)",", this.exposedHeaders);
        return this;
    }

    public CorsHandler allowedMethod(ScxHttpMethod ... methods) {
        return this.allowedMethod((String[])Arrays.stream(methods).map(ScxHttpMethod::value).toArray(String[]::new));
    }

    public CorsHandler allowedHeader(ScxHttpHeaderName ... headerNames) {
        return this.allowedHeader((String[])Arrays.stream(headerNames).map(ScxHttpHeaderName::value).toArray(String[]::new));
    }

    public CorsHandler exposedHeader(ScxHttpHeaderName ... headerNames) {
        return this.allowedHeader((String[])Arrays.stream(headerNames).map(ScxHttpHeaderName::value).toArray(String[]::new));
    }

    public CorsHandler allowCredentials(boolean allow) {
        this.allowCredentials = allow;
        return this;
    }

    public CorsHandler maxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds == -1 ? null : String.valueOf(maxAgeSeconds);
        return this;
    }

    @Override
    public void accept(RoutingContext context) {
        Object request = context.request();
        Object response = context.response();
        String origin = context.request().getHeader(HttpFieldName.ORIGIN);
        if (origin == null) {
            context.next();
        } else if (this.isValidOrigin(origin)) {
            String accessControlRequestMethod = (String)request.headers().get(HttpFieldName.ACCESS_CONTROL_REQUEST_METHOD);
            if (request.method() == HttpMethod.OPTIONS && accessControlRequestMethod != null) {
                this.addCredentialsAndOriginHeader((ScxHttpServerResponse)response, origin);
                if (this.allowedMethodsString != null) {
                    response.setHeader(HttpFieldName.ACCESS_CONTROL_ALLOW_METHODS, this.allowedMethodsString);
                }
                if (this.allowedHeadersString != null) {
                    response.setHeader(HttpFieldName.ACCESS_CONTROL_ALLOW_HEADERS, this.allowedHeadersString);
                } else if (request.headers().contains(HttpFieldName.ACCESS_CONTROL_REQUEST_HEADERS)) {
                    response.setHeader(HttpFieldName.ACCESS_CONTROL_ALLOW_HEADERS, request.getHeader(HttpFieldName.ACCESS_CONTROL_REQUEST_HEADERS));
                }
                if (this.maxAgeSeconds != null) {
                    response.setHeader(HttpFieldName.ACCESS_CONTROL_MAX_AGE, this.maxAgeSeconds);
                }
                response.status(204).send();
            } else {
                this.addCredentialsAndOriginHeader((ScxHttpServerResponse)response, origin);
                if (this.exposedHeadersString != null) {
                    response.setHeader(HttpFieldName.ACCESS_CONTROL_EXPOSE_HEADERS, this.exposedHeadersString);
                }
                context.next();
            }
        } else {
            throw new ForbiddenException("CORS Rejected - Invalid origin");
        }
    }

    private void addCredentialsAndOriginHeader(ScxHttpServerResponse response, String origin) {
        if (this.allowCredentials) {
            response.setHeader(HttpFieldName.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            response.setHeader(HttpFieldName.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        } else {
            response.setHeader(HttpFieldName.ACCESS_CONTROL_ALLOW_ORIGIN, this.getAllowedOrigin(origin));
        }
    }

    private boolean isValidOrigin(String origin) {
        if (this.starOrigin()) {
            return true;
        }
        for (String allowedOrigin : this.origins) {
            if (!allowedOrigin.equals(origin)) continue;
            return true;
        }
        return false;
    }

    private String getAllowedOrigin(String origin) {
        if (this.starOrigin()) {
            return "*";
        }
        return origin;
    }
}

