/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing.handler;

import cool.scx.http.HttpFieldName;
import cool.scx.http.HttpMethod;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.handler.StaticHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;

public class StaticHandler
implements Consumer<RoutingContext> {
    private final Path root;

    public StaticHandler(Path root) {
        this.root = root;
    }

    @Override
    public void accept(RoutingContext routingContext) {
        Object request = routingContext.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            routingContext.next();
            return;
        }
        String p = routingContext.pathParams().get("*");
        Path filePath = this.getFilePath(p);
        boolean notExists = Files.notExists(filePath, new LinkOption[0]);
        if (notExists) {
            routingContext.next();
            return;
        }
        try {
            BasicFileAttributes attr = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            String lastModifiedTime = attr.lastModifiedTime().toInstant().atZone(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
            String etag = "\"" + attr.lastModifiedTime().toMillis() + "\"";
            String ifNoneMatch = request.getHeader("If-None-Match");
            String ifModifiedSince = request.getHeader("If-Modified-Since");
            if (etag.equals(ifNoneMatch) || lastModifiedTime.equals(ifModifiedSince)) {
                routingContext.response().status(304).send();
                return;
            }
            routingContext.response().setHeader(HttpFieldName.CACHE_CONTROL, "public,immutable,max-age=2628000");
            routingContext.response().setHeader(HttpFieldName.ETAG, etag);
            routingContext.response().setHeader(HttpFieldName.LAST_MODIFIED, lastModifiedTime);
            StaticHelper.sendStatic(filePath, routingContext);
        }
        catch (IOException e) {
            routingContext.next();
        }
    }

    public Path getFilePath(String p) {
        boolean regularFile = Files.isRegularFile(this.root, new LinkOption[0]);
        if (regularFile) {
            return this.root;
        }
        Path path = this.root.resolve(p).normalize();
        if (!path.startsWith(this.root)) {
            throw new NotFoundException();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path.resolve("index.html");
        }
        return path;
    }
}

