/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.ScxHttpMethod;

public enum HttpMethod implements ScxHttpMethod
{
    CONNECT("CONNECT"),
    DELETE("DELETE"),
    GET("GET"),
    HEAD("HEAD"),
    OPTIONS("OPTIONS"),
    PATCH("PATCH"),
    POST("POST"),
    PUT("PUT"),
    TRACE("TRACE");

    private final String value;

    private HttpMethod(String value) {
        this.value = value;
    }

    public static HttpMethod of(String v) {
        HttpMethod h = HttpMethod.find(v);
        if (h == null) {
            throw new IllegalArgumentException("Unknown http method: " + v);
        }
        return h;
    }

    public static HttpMethod find(String v) {
        return switch (v) {
            case "CONNECT" -> CONNECT;
            case "DELETE" -> DELETE;
            case "GET" -> GET;
            case "HEAD" -> HEAD;
            case "OPTIONS" -> OPTIONS;
            case "PATCH" -> PATCH;
            case "POST" -> POST;
            case "PUT" -> PUT;
            case "TRACE" -> TRACE;
            default -> null;
        };
    }

    @Override
    public String value() {
        return this.value;
    }
}

