/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.ScxMediaType;
import java.util.HashMap;
import java.util.Map;

public enum MediaType implements ScxMediaType
{
    TEXT_PLAIN("text", "plain"),
    TEXT_HTML("text", "html"),
    TEXT_CSS("text", "css"),
    TEXT_JS("text", "javascript"),
    APPLICATION_OCTET_STREAM("application", "octet-stream"),
    APPLICATION_X_WWW_FORM_URLENCODED("application", "x-www-form-urlencoded"),
    APPLICATION_XML("application", "xml"),
    APPLICATION_JSON("application", "json"),
    APPLICATION_ZIP("application", "zip"),
    APPLICATION_PDF("application", "pdf"),
    APPLICATION_DOC("application", "msword"),
    APPLICATION_XLS("application", "vnd.ms-excel"),
    APPLICATION_PPT("application", "vnd.ms-powerpoint"),
    APPLICATION_DOCX("application", "vnd.openxmlformats-officedocument.wordprocessingml.document"),
    APPLICATION_XLSX("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    APPLICATION_PPTX("application", "vnd.openxmlformats-officedocument.presentationml.presentation"),
    APPLICATION_APK("application", "vnd.android.package-archive"),
    IMAGE_BMP("image", "bmp"),
    IMAGE_PNG("image", "png"),
    IMAGE_JPEG("image", "jpeg"),
    IMAGE_GIF("image", "gif"),
    IMAGE_SVG("image", "svg+xml"),
    IMAGE_WEBP("image", "webp"),
    AUDIO_MPEG("audio", "mpeg"),
    AUDIO_WAV("audio", "wav"),
    VIDEO_MP4("video", "mp4"),
    VIDEO_WEBM("video", "webm"),
    MULTIPART_FORM_DATA("multipart", "form-data");

    private static final Map<String, MediaType> MAP;
    private final String type;
    private final String subtype;
    private final String value;

    private MediaType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
        this.value = type + "/" + subtype;
    }

    private static HashMap<String, MediaType> initMap() {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>();
        for (MediaType h : MediaType.values()) {
            map.put(h.value(), h);
        }
        return map;
    }

    public static MediaType of(String str) {
        MediaType mediaType = MediaType.find(str);
        if (mediaType == null) {
            throw new IllegalArgumentException("Unknown media type: " + str);
        }
        return mediaType;
    }

    public static MediaType find(String str) {
        return MAP.get(str.toLowerCase());
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String subtype() {
        return this.subtype;
    }

    @Override
    public String value() {
        return this.value;
    }

    static {
        MAP = MediaType.initMap();
    }
}

