/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import java.io.InputStream;
import java.io.OutputStream;

public class MultiPartWriter
implements MediaWriter {
    private final MultiPart multiPart;

    public MultiPartWriter(MultiPart multiPart) {
        this.multiPart = multiPart;
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            responseHeaders.contentType(ContentType.of().mediaType(MediaType.MULTIPART_FORM_DATA).boundary(this.multiPart.boundary()));
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        byte[] h = ("--" + this.multiPart.boundary() + "\r\n").getBytes();
        byte[] f = ("--" + this.multiPart.boundary() + "--\r\n").getBytes();
        byte[] l = "\r\n".getBytes();
        try (OutputStream outputStream2 = outputStream;){
            for (MultiPartPart multiPartPart : this.multiPart) {
                outputStream.write(h);
                String headers = multiPartPart.headers().encode();
                outputStream.write(headers.getBytes());
                outputStream.write(l);
                try (InputStream i = multiPartPart.inputStream();){
                    i.transferTo(outputStream);
                }
                outputStream.write(l);
            }
            outputStream.write(f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

