/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.path;

import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.io.IOHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

public class PathWriter
implements MediaWriter {
    private final Path path;
    private final long fileRealSize;
    private final long offset;
    private final long length;

    public PathWriter(Path path) {
        this.path = path;
        this.fileRealSize = IOHelper.getFileSize((Path)path);
        this.offset = 0L;
        this.length = this.fileRealSize;
    }

    public PathWriter(Path path, long offset, long length) {
        this.path = path;
        this.fileRealSize = IOHelper.getFileSize((Path)path);
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentLength() == null) {
            responseHeaders.contentLength(this.length);
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        try (OutputStream outputStream2 = outputStream;){
            if (this.offset == 0L && this.length == this.fileRealSize) {
                IOHelper.writeFileToOut((Path)this.path, (OutputStream)outputStream);
            } else {
                IOHelper.writeFileToOut((Path)this.path, (OutputStream)outputStream, (long)this.offset, (long)this.length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

