/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.byte_array.ByteArrayWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsWriter;
import cool.scx.http.media.input_stream.InputStreamWriter;
import cool.scx.http.media.json_node.JsonNodeWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartWriter;
import cool.scx.http.media.object.ObjectWriter;
import cool.scx.http.media.path.PathWriter;
import cool.scx.http.media.string.StringWriter;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.method.HttpMethod;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.version.HttpVersion;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;

public interface ScxHttpClientRequest {
    public HttpVersion version();

    public ScxHttpMethod method();

    public ScxURIWritable uri();

    public ScxHttpHeadersWritable headers();

    public ScxHttpClientRequest version(HttpVersion var1);

    public ScxHttpClientRequest method(HttpMethod var1);

    public ScxHttpClientRequest uri(ScxURI var1);

    public ScxHttpClientRequest headers(ScxHttpHeaders var1);

    public ScxHttpClientResponse send(MediaWriter var1);

    default public ScxHttpClientResponse send() {
        return this.send(new EmptyWriter());
    }

    default public ScxHttpClientResponse send(byte[] bytes) {
        return this.send(new ByteArrayWriter(bytes));
    }

    default public ScxHttpClientResponse send(String str) {
        return this.send(new StringWriter(str));
    }

    default public ScxHttpClientResponse send(String str, Charset charset) {
        return this.send(new StringWriter(str, charset));
    }

    default public ScxHttpClientResponse send(Path path) {
        return this.send(new PathWriter(path));
    }

    default public ScxHttpClientResponse send(Path path, long offset, long length) {
        return this.send(new PathWriter(path, offset, length));
    }

    default public ScxHttpClientResponse send(InputStream inputStream) {
        return this.send(new InputStreamWriter(inputStream));
    }

    default public ScxHttpClientResponse send(FormParams formParams) {
        return this.send(new FormParamsWriter(formParams));
    }

    default public ScxHttpClientResponse send(MultiPart multiPart) {
        return this.send(new MultiPartWriter(multiPart));
    }

    default public ScxHttpClientResponse send(JsonNode jsonNode) {
        return this.send(new JsonNodeWriter(jsonNode));
    }

    default public ScxHttpClientResponse send(Object object) {
        return this.send(new ObjectWriter(object));
    }

    default public ScxHttpClientRequest uri(String uri) {
        return this.uri(ScxURI.of(uri));
    }

    default public ScxHttpClientRequest setHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest addHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest setHeader(String headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest addHeader(String headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpClientRequest addCookie(Cookie ... cookie) {
        this.headers().addCookie(cookie);
        return this;
    }

    default public ScxHttpClientRequest removeCookie(String name) {
        this.headers().removeCookie(name);
        return this;
    }

    default public ScxMediaType contentType() {
        return this.headers().contentType();
    }

    default public ScxHttpClientRequest contentType(ScxMediaType mediaType) {
        this.headers().contentType(mediaType);
        return this;
    }

    default public Long contentLength() {
        return this.headers().contentLength();
    }

    default public ScxHttpClientRequest contentLength(long contentLength) {
        this.headers().contentLength(contentLength);
        return this;
    }
}

