/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.accept;

import cool.scx.http.headers.accept.MediaRangeHelper;
import cool.scx.http.headers.accept.MediaRangeImpl;
import cool.scx.http.headers.accept.MediaRangeWritable;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.parameters.Parameters;

public interface MediaRange {
    public static MediaRangeWritable of(String mediaRangeStr) {
        return MediaRangeHelper.parseMediaRange(mediaRangeStr);
    }

    public static MediaRangeWritable of() {
        return new MediaRangeImpl();
    }

    public String type();

    public String subtype();

    public Parameters<String, String> params();

    default public Double q() {
        String s = this.params().get("q");
        return s != null ? Double.parseDouble(s) : 1.0;
    }

    default public boolean matches(ScxMediaType mediaType) {
        boolean typeMatch = this.type().equals("*") || this.type().equals(mediaType.type());
        boolean subtypeMatch = this.subtype().equals("*") || this.subtype().equals(mediaType.subtype());
        return typeMatch && subtypeMatch;
    }

    default public boolean exactMatch(ScxMediaType mediaType) {
        boolean typeMatch = this.type().equals(mediaType.type());
        boolean subtypeMatch = this.subtype().equals(mediaType.subtype());
        return typeMatch && subtypeMatch;
    }
}

