/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.json_node;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.accept.Accept;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class JsonNodeWriter
implements MediaWriter {
    private final JsonNode jsonNode;
    private byte[] data;

    public JsonNodeWriter(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        this.data = null;
    }

    public static ScxMediaType trySetContentType(ScxHttpHeadersWritable headersWritable, ScxHttpHeaders headers) {
        if (headersWritable.contentType() != null) {
            return headersWritable.contentType();
        }
        Accept accept = headers.accept();
        if (accept == null) {
            headersWritable.contentType(ScxMediaType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8));
            return headersWritable.contentType();
        }
        MediaType mediaType = (MediaType)accept.negotiate(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML});
        if (mediaType == MediaType.APPLICATION_XML) {
            headersWritable.contentType(ScxMediaType.of(MediaType.APPLICATION_XML).charset(StandardCharsets.UTF_8));
        } else {
            headersWritable.contentType(ScxMediaType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8));
        }
        return headersWritable.contentType();
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block5: {
            ScxMediaType contentType = JsonNodeWriter.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.jsonMapper().writeValueAsString((Object)this.jsonNode).getBytes(StandardCharsets.UTF_8);
                    break block5;
                }
                if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.xmlMapper().writeValueAsString((Object)this.jsonNode).getBytes(StandardCharsets.UTF_8);
                    break block5;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType));
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (responseHeaders.contentLength() == null) {
            responseHeaders.contentLength(this.data.length);
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

