/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.object;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.json_node.JsonNodeWriter;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class ObjectWriter
implements MediaWriter {
    private final Object object;
    private byte[] data;

    public ObjectWriter(Object object) {
        this.object = object;
        this.data = null;
    }

    @Override
    public void beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block5: {
            ScxMediaType contentType = JsonNodeWriter.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.toJson((Object)this.object).getBytes(StandardCharsets.UTF_8);
                    break block5;
                }
                if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.toXml((Object)this.object).getBytes(StandardCharsets.UTF_8);
                    break block5;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType));
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (responseHeaders.contentLength() == null) {
            responseHeaders.contentLength(this.data.length);
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

