/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.string;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringReader
implements MediaReader<String> {
    public static final StringReader STRING_READER = new StringReader();
    private final Charset charset;

    public StringReader(Charset charset) {
        this.charset = charset;
    }

    private StringReader() {
        this.charset = null;
    }

    public static Charset getContentTypeCharsetOrUTF8(ScxHttpHeaders headers) {
        Charset charset;
        ScxMediaType contentType = headers.contentType();
        if (contentType != null && (charset = contentType.charset()) != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public String read(InputStream inputStream, ScxHttpHeaders headers) {
        String string;
        block8: {
            Charset c = this.charset != null ? this.charset : StringReader.getContentTypeCharsetOrUTF8(headers);
            InputStream inputStream2 = inputStream;
            try {
                byte[] bytes = inputStream.readAllBytes();
                string = new String(bytes, c);
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream2.close();
        }
        return string;
    }
}

