/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media_type;

import cool.scx.http.media_type.ScxMediaTypeHelper;
import cool.scx.http.media_type.ScxMediaTypeImpl;
import cool.scx.http.media_type.ScxMediaTypeWritable;
import cool.scx.http.parameters.Parameters;
import java.nio.charset.Charset;

public interface ScxMediaType {
    public static ScxMediaTypeWritable of() {
        return new ScxMediaTypeImpl();
    }

    public static ScxMediaTypeWritable of(ScxMediaType oldMediaType) {
        return new ScxMediaTypeImpl(oldMediaType.type(), oldMediaType.subtype(), oldMediaType.params());
    }

    public static ScxMediaTypeWritable of(String mediaTypeStr) {
        return ScxMediaTypeHelper.decodedMediaType(mediaTypeStr);
    }

    public String type();

    public String subtype();

    public Parameters<String, String> params();

    default public boolean equalsIgnoreParams(ScxMediaType other) {
        if (other == null) {
            return false;
        }
        return this.type().equalsIgnoreCase(other.type()) && this.subtype().equalsIgnoreCase(other.subtype());
    }

    default public String encode() {
        return ScxMediaTypeHelper.encodeMediaType(this);
    }

    default public Charset charset() {
        String charset = this.params().get("charset");
        return charset == null ? null : Charset.forName(charset);
    }

    default public String boundary() {
        return this.params().get("boundary");
    }
}

