/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeadersImpl;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.accept.Accept;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.headers.cookie.Cookies;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.parameters.Parameters;
import java.util.List;

public interface ScxHttpHeaders
extends Parameters<ScxHttpHeaderName, String> {
    public static ScxHttpHeadersWritable of() {
        return new ScxHttpHeadersImpl();
    }

    public static ScxHttpHeadersWritable of(ScxHttpHeaders oldHeaders) {
        return new ScxHttpHeadersImpl(oldHeaders);
    }

    @Override
    default public String get(String name) {
        return (String)this.get(ScxHttpHeaderName.of(name));
    }

    @Override
    default public List<String> getAll(String name) {
        return this.getAll(ScxHttpHeaderName.of(name));
    }

    @Override
    default public boolean contains(String name) {
        return this.contains(ScxHttpHeaderName.of(name));
    }

    default public Cookies cookies() {
        String c = (String)this.get(HttpFieldName.COOKIE);
        return c != null ? Cookies.of(c) : null;
    }

    default public Cookies setCookies() {
        List c = this.getAll(HttpFieldName.SET_COOKIE);
        return !c.isEmpty() ? Cookies.of((String[])c.toArray(String[]::new)) : null;
    }

    default public ScxMediaType contentType() {
        String v = (String)this.get(HttpFieldName.CONTENT_TYPE);
        return v != null ? ScxMediaType.of(v) : null;
    }

    default public ContentDisposition contentDisposition() {
        String c = (String)this.get(HttpFieldName.CONTENT_DISPOSITION);
        return c != null ? ContentDisposition.of(c) : null;
    }

    default public Long contentLength() {
        String c = (String)this.get(HttpFieldName.CONTENT_LENGTH);
        return c != null ? Long.valueOf(Long.parseLong(c)) : null;
    }

    default public Cookie getCookie(String name) {
        Cookies v = this.cookies();
        return v != null ? v.get(name) : null;
    }

    default public Cookie getSetCookie(String name) {
        Cookies v = this.setCookies();
        return v != null ? v.get(name) : null;
    }

    default public Accept accept() {
        String c = (String)this.get(HttpFieldName.ACCEPT);
        return c != null ? Accept.of(c) : null;
    }
}

