/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.content_disposition;

import cool.scx.common.util.StringUtils;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.headers.content_disposition.ContentDispositionImpl;
import cool.scx.http.headers.content_disposition.ContentDispositionWritable;
import cool.scx.http.media_type.ScxMediaTypeHelper;
import cool.scx.http.parameters.Parameters;
import cool.scx.http.parameters.ParametersWritable;

public class ContentDispositionHelper {
    public static ContentDispositionWritable decodedContentDisposition(String contentDispositionStr) {
        if (contentDispositionStr == null) {
            return null;
        }
        String[] parts = ScxMediaTypeHelper.SEMICOLON_PATTERN.split(contentDispositionStr);
        if (parts.length == 0) {
            return null;
        }
        String type = parts[0];
        ParametersWritable<String, String> params = Parameters.of();
        for (int i = 1; i < parts.length; ++i) {
            String[] s = parts[i].split("=", 2);
            if (s.length != 2) continue;
            params.add(s[0], (String[])new String[]{StringUtils.removeQuotes((String)s[1])});
        }
        return new ContentDispositionImpl().type(type).params(params);
    }

    public static String encodeContentDisposition(ContentDisposition contentDisposition) {
        String type = contentDisposition.type();
        Parameters<String, String> params = contentDisposition.params();
        StringBuilder sb = new StringBuilder(type);
        if (params != null) {
            ScxMediaTypeHelper.encodeParams(sb, params);
        }
        return sb.toString();
    }
}

