/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.cookie;

public enum CookieSameSite {
    NONE("None"),
    STRICT("Strict"),
    LAX("Lax");

    private final String value;

    private CookieSameSite(String label) {
        this.value = label;
    }

    public static CookieSameSite of(String attrValue) {
        if ("None".equalsIgnoreCase(attrValue)) {
            return NONE;
        }
        if ("Strict".equalsIgnoreCase(attrValue)) {
            return STRICT;
        }
        if ("Lax".equalsIgnoreCase(attrValue)) {
            return LAX;
        }
        throw new IllegalArgumentException("Unknown cookie same site: " + attrValue);
    }

    public static CookieSameSite find(String attrValue) {
        if ("None".equalsIgnoreCase(attrValue)) {
            return NONE;
        }
        if ("Strict".equalsIgnoreCase(attrValue)) {
            return STRICT;
        }
        if ("Lax".equalsIgnoreCase(attrValue)) {
            return LAX;
        }
        return null;
    }

    public String value() {
        return this.value;
    }
}

